# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 158-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(53416);
 script_version ("$");
 name = "Debian Security Advisory DSA 158-1 (gaim)";
 script_name(name);

 desc = "The remote host is missing an update to gaim
announced via advisory DSA 158-1.

The developers of Gaim, an instant messenger client that combines
several different networks, found a vulnerability in the hyperlink
handling code.  The 'Manual' browser command passes an untrusted
string to the shell without escaping or reliable quoting, permitting
an attacker to execute arbitrary commands on the users machine.
Unfortunately, Gaim doesn't display the hyperlink before the user
clicks on it.  Users who use other inbuilt browser commands aren't
vulnerable.

This problem has been fixed in version 0.58-2.2 for the current
stable distribution (woody) and in version 0.59.1-2 for the unstable
distribution (sid).  The old stable distribution (potato) is not
affected since it doesn't ship the Gaim program.

The fixed version of Gaim no longer passes the user's manual browser
command to the shell.  Commands which contain the %s in quotes will
need to be amended, so they don't contain any quotes.  The 'Manual'
browser command can be edited in the 'General' pane of the
'Preferences' dialog, which can be accessed by clicking 'Options' from
the login window, or 'Tools' and then 'Preferences' from the menu bar
in the buddy list window.

We recommend that you upgrade your gaim package immediately.


Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20158-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 158-1 (gaim)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"gaim", ver:"0.58-2.2", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"gaim-common", ver:"0.58-2.2", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"gaim-gnome", ver:"0.58-2.2", rls:"DEB3.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
