# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1627-2 (opensc)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(61590);
 script_cve_id("CVE-2008-2235");
 script_version ("$");
 name = "Debian Security Advisory DSA 1627-2 (opensc)";
 script_name(name);

 desc = "The remote host is missing an update to opensc
announced via advisory DSA 1627-2.

The previous security update for opensc had a too strict check for
vulnerable smart cards. It could flag cards as safe even though they may
be affected. This update corrects that problem. We advise users of the
smart cards concerned to re-check their card after updating the package,
following the procedure outlined in the original advisory text below.

Chaskiel M Grundman discovered that opensc, a library and utilities to
handle smart cards, would initialise smart cards with the Siemens CardOS M4
card operating system without proper access rights. This allowed everyone
to change the card's PIN.

With this bug anyone can change a user PIN without having the PIN or PUK
or the superusers PIN or PUK. However it can not be used to figure out the
PIN. If the PIN on your card is still the same you always had, there's a
reasonable chance that this vulnerability has not been exploited.

This vulnerability affects only smart cards and USB crypto tokens based on
Siemens CardOS M4, and within that group only those that were initialised
with OpenSC. Users of other smart cards and USB crypto tokens, or cards
that have been initialised with some software other than OpenSC, are not
affected.

After upgrading the package, running
pkcs15-tool -T
will show you whether the card is fine or vulnerable. If the card is
vulnerable, you need to update the security setting using:
pkcs15-tool -T -U

For the stable distribution (etch), this problem has been fixed in
version 0.11.1-2etch2.

For the unstable distribution (sid), this problem has been fixed in
version 0.11.4-5.

We recommend that you upgrade your opensc package and check your card(s)

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201627-2

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 1627-2 (opensc)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"opensc", ver:"0.11.1-2etch2", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"mozilla-opensc", ver:"0.11.1-2etch2", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libopensc2-dbg", ver:"0.11.1-2etch2", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libopensc2-dev", ver:"0.11.1-2etch2", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libopensc2", ver:"0.11.1-2etch2", rls:"DEB4.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
