# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1634-2 (wordnet)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(61643);
 script_cve_id("CVE-2008-2149");
 script_version ("$");
 name = "Debian Security Advisory DSA 1634-2 (wordnet)";
 script_name(name);

 desc = "The remote host is missing an update to wordnet
announced via advisory DSA 1634-2.

A regression was discovered in the original patch addressing this issue
for WordNet, which this update fixes. For reference the text of the
original advisory follows.

Rob Holland discovered several programming errors in WordNet, an
electronic lexical database of the English language. These flaws could
allow arbitrary code execution when used with untrusted input, for
example when WordNet is in use as a back end for a web application.

For the stable distribution (etch), these problems have been fixed in
version 1:2.1-4+etch2.

For the unstable distribution (sid), these problems have been fixed in
version 1:3.0-13.

We recommend that you upgrade your wordnet package.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201634-2

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 1634-2 (wordnet)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"wordnet-base", ver:"2.1-4+etch2", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"wordnet-sense-index", ver:"2.1-4+etch2", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"wordnet", ver:"2.1-4+etch2", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"wordnet-dev", ver:"2.1-4+etch2", rls:"DEB4.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
