# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1638-1 (openssh)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(61639);
 script_cve_id("CVE-2008-4109", "CVE-2006-5051");
 script_version ("$");
 name = "Debian Security Advisory DSA 1638-1 (openssh)";
 script_name(name);

 desc = "The remote host is missing an update to openssh
announced via advisory DSA 1638-1.

It has been discovered that the signal handler implementing the login
timeout in Debian's version of the OpenSSH server uses functions which
are not async-signal-safe, leading to a denial of service
vulnerability (CVE-2008-4109).

The problem was originally corrected in OpenSSH 4.4p1 (CVE-2006-5051),
but the patch backported to the version released with etch was
incorrect.

Systems affected by this issue suffer from lots of zombie sshd
processes.  Processes stuck with a [net] process title have also been
observed.  Over time, a sufficient number of processes may accumulate
such that further login attempts are impossible.  Presence of these
processes does not indicate active exploitation of this vulnerability.
It is possible to trigger this denial of service condition by accident.

For the stable distribution (etch), this problem has been fixed in
version 4.3p2-9etch3.

For the unstable distribution (sid) and the testing distribution
(lenny), this problem has been fixed in version 4.6p1-1.

We recommend that you upgrade your openssh packages.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201638-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 1638-1 (openssh)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"ssh-krb5", ver:"4.3p2-9etch3", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"ssh", ver:"4.3p2-9etch3", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"openssh-client", ver:"4.3p2-9etch3", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"ssh-askpass-gnome", ver:"4.3p2-9etch3", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"openssh-server", ver:"4.3p2-9etch3", rls:"DEB4.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
