# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1641-1 (phpmyadmin)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(61644);
 script_cve_id("CVE-2008-3197", "CVE-2008-3456", "CVE-2008-3457", "CVE-2008-4096");
 script_version ("$");
 name = "Debian Security Advisory DSA 1641-1 (phpmyadmin)";
 script_name(name);

 desc = "The remote host is missing an update to phpmyadmin
announced via advisory DSA 1641-1.

Several remote vulnerabilities have been discovered in phpMyAdmin, a
tool to administrate MySQL databases over the web. The Common
Vulnerabilities and Exposures project identifies the following problems:

CVE-2008-4096

Remote authenticated users could execute arbitrary code on the
host running phpMyAdmin through manipulation of a script parameter.

CVE-2008-3457

Cross site scripting through the setup script was possible in
rare circumstances.

CVE-2008-3456

Protection has been added against remote websites loading phpMyAdmin
into a frameset.

CVE-2008-3197

Cross site request forgery allowed remote attackers to create a new
database, but not perform any other action on it.

For the stable distribution (etch), these problems have been fixed in
version 4:2.9.1.1-8.

For the unstable distribution (sid), these problems have been fixed in
version 4:2.11.8.1-2.

We recommend that you upgrade your phpmyadmin package.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201641-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 1641-1 (phpmyadmin)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"phpmyadmin", ver:"2.9.1.1-8", rls:"DEB4.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
