# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1671-1 (iceweasel)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(61934);
 script_cve_id("CVE-2008-0017", "CVE-2008-4582", "CVE-2008-5012", "CVE-2008-5013", "CVE-2008-5014", "CVE-2008-5017", "CVE-2008-5018", "CVE-2008-5021", "CVE-2008-5022", "CVE-2008-5023", "CVE-2008-5024");
 script_version ("$");
 name = "Debian Security Advisory DSA 1671-1 (iceweasel)";
 script_name(name);

 desc = "The remote host is missing an update to iceweasel
announced via advisory DSA 1671-1.

Several remote vulnerabilities have been discovered in the Iceweasel
webbrowser, an unbranded version of the Firefox browser. The Common
Vulnerabilities and Exposures project identifies the following problems:

CVE-2008-0017

Justin Schuh discovered that a buffer overflow in the http-index-format
parser could lead to arbitrary code execution.

CVE-2008-4582

Liu Die Yu discovered an information leak through local shortcut
files.

CVE-2008-5012

Georgi Guninski, Michal Zalewski and Chris Evan discovered that
the canvas element could be used to bypass same-origin
restrictions.

CVE-2008-5013

It was discovered that insufficient checks in the Flash plugin glue
code could lead to arbitrary code execution.

CVE-2008-5014

Jesse Ruderman discovered that a programming error in the
window.__proto__.__proto__ object could lead to arbitrary code
execution.

CVE-2008-5017

It was discovered that crashes in the layout engine could lead to
arbitrary code execution.

CVE-2008-5018

It was discovered that crashes in the Javascript engine could lead to
arbitrary code execution.

CVE-2008-5021

It was discovered that a crash in the nsFrameManager might lead to
the execution of arbitrary code.

CVE-2008-5022

moz_bug_r_a4 discovered that the same-origin check in
nsXMLHttpRequest::NotifyEventListeners() could be bypassed.

CVE-2008-5023

Collin Jackson discovered that the -moz-binding property bypasses
security checks on codebase principals.

CVE-2008-5024

Chris Evans discovered that quote characters were improperly
escaped in the default namespace of E4X documents.

For the stable distribution (etch), these problems have been fixed in
version 2.0.0.18-0etch1.

For the upcoming stable distribution (lenny) and the unstable distribution
(sid), these problems have been fixed in version 3.0.4-1 of iceweasel
and version 1.9.0.4-1 of xulrunner. Packages for arm and mips will be
provided soon.

We recommend that you upgrade your iceweasel package.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201671-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 1671-1 (iceweasel)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"mozilla-firefox-gnome-support", ver:"2.0.0.18-0etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"firefox-dom-inspector", ver:"2.0.0.18-0etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"firefox-gnome-support", ver:"2.0.0.18-0etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"firefox", ver:"2.0.0.18-0etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"mozilla-firefox", ver:"2.0.0.18-0etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"iceweasel-dom-inspector", ver:"2.0.0.18-0etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"mozilla-firefox-dom-inspector", ver:"2.0.0.18-0etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"iceweasel", ver:"2.0.0.18-0etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"iceweasel-dbg", ver:"2.0.0.18-0etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"iceweasel-gnome-support", ver:"2.0.0.18-0etch1", rls:"DEB4.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
