# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1701-1 (openssl, openssl097)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(63148);
 script_cve_id("CVE-2008-5077");
 script_version ("$");
 name = "Debian Security Advisory DSA 1701-1 (openssl, openssl097)";
 script_name(name);

 desc = "The remote host is missing an update to openssl, openssl097
announced via advisory DSA 1701-1.

It was discovered that OpenSSL does not properly verify DSA signatures
on X.509 certificates due to an API misuse, potentially leading to the
acceptance of incorrect X.509 certificates as genuine (CVE-2008-5077).

For the stable distribution (etch), this problem has been fixed in
version 0.9.8c-4etch4 of the openssl package, and version
0.9.7k-3.1etch2 of the openssl097 package.

For the unstable distribution (sid), this problem has been fixed in
version 0.9.8g-15.

The testing distribution (lenny) will be fixed soon.

We recommend that you upgrade your OpenSSL packages.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201701-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 1701-1 (openssl, openssl097)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"libssl-dev", ver:"0.9.8c-4etch4", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libssl0.9.7-dbg", ver:"0.9.7k-3.1etch2", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libssl0.9.7", ver:"0.9.7k-3.1etch2", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libssl0.9.8-dbg", ver:"0.9.8c-4etch4", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"openssl", ver:"0.9.8c-4etch4", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libssl0.9.8", ver:"0.9.8c-4etch4", rls:"DEB4.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
