# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1715-1 (moin)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(63301);
 script_cve_id("CVE-2009-0260", "CVE-2009-0312");
 script_version ("$");
 name = "Debian Security Advisory DSA 1715-1 (moin)";
 script_name(name);

 desc = "The remote host is missing an update to moin
announced via advisory DSA 1715-1.

It was discovered that the AttachFile action in moin, a python clone of
WikiWiki, is prone to cross-site scripting attacks (CVE-2009-0260).
Another cross-site scripting vulnerability was discovered in the
antispam feature (CVE-2009-0312).

For the stable distribution (etch) these problems have been fixed in
version 1.5.3-1.2etch2.

For the testing (lenny) distribution these problems have been fixed in
version 1.7.1-3+lenny1.

For the unstable (sid) distribution these problems have been fixed in
version 1.8.1-1.1.

We recommend that you upgrade your moin packages.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201715-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 1715-1 (moin)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"python-moinmoin", ver:"1.5.3-1.2etch2", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"moinmoin-common", ver:"1.5.3-1.2etch2", rls:"DEB4.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
