# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1720-1 (typo3-src)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(63393);
 script_version ("$");
 name = "Debian Security Advisory DSA 1720-1 (typo3-src)";
 script_name(name);

 desc = "The remote host is missing an update to typo3-src
announced via advisory DSA 1720-1.

Several remote vulnerabilities have been discovered in the TYPO3 web
content management framework.

Marcus Krause and Michael Stucki from the TYPO3 security team
discovered that the jumpUrl mechanism discloses secret hashes enabling
a remote attacker to bypass access control by submitting the correct
value as a URL parameter and thus being able to read the content of
arbitrary files.

Jelmer de Hen and Dmitry Dulepov discovered multiple cross-site
scripting vulnerabilities in the backend user interface allowing
remote attackers to inject arbitrary web script or HTML.

As it is very likely that your encryption key has been exposed we
strongly recommend to change your encyption key via the install tool
after installing the update.

For the stable distribution (etch) these problems have been fixed in
version 4.0.2+debian-8.

For the testing distribution (lenny) these problems have been fixed in
version 4.2.5-1+lenny1.

For the unstable distribution (sid) these problems have been fixed in
version 4.2.6-1.

We recommend that you upgrade your typo3 package.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201720-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 1720-1 (typo3-src)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"typo3-src-4.0", ver:"4.0.2+debian-8", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"typo3", ver:"4.0.2+debian-8", rls:"DEB4.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
