# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1726-1 (python-crypto)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(63572);
 script_cve_id("CVE-2009-0544");
 script_version ("$");
 name = "Debian Security Advisory DSA 1726-1 (python-crypto)";
 script_name(name);

 desc = "The remote host is missing an update to python-crypto
announced via advisory DSA 1726-1.

Mike Wiacek discovered that a buffer overflow in the ARC2 implementation
of Python Crypto, a collection of cryptographic algorithms and protocols
for Python allows denial of service and potentially the execution of
arbitrary code.

For the stable distribution (lenny), this problem has been fixed in
version 2.0.1+dfsg1-2.3+lenny0.

Due to a technical limitation in the Debian archive management scripts
the update for the old stable distribution (etch) cannot be released
synchronously. It will be fixed in version 2.0.1+dfsg1-1.2+etch0 soon.

For the unstable distribution (sid), this problem will be fixed soon.

We recommend that you upgrade your python-crypto package.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201726-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 1726-1 (python-crypto)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"python-crypto-dbg", ver:"2.0.1+dfsg1-2.3+lenny0", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"python-crypto", ver:"2.0.1+dfsg1-2.3+lenny0", rls:"DEB5.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
