# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1729-1 (gst-plugins-bad0.10)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(63496);
 script_cve_id("CVE-2009-0386", "CVE-2009-0387", "CVE-2009-0397");
 script_version ("$");
 name = "Debian Security Advisory DSA 1729-1 (gst-plugins-bad0.10)";
 script_name(name);

 desc = "The remote host is missing an update to gst-plugins-bad0.10
announced via advisory DSA 1729-1.

Several vulnerabilities have been found in gst-plugins-bad0.10, a
collection of various GStreamer plugins. The Common Vulnerabilities and
Exposures project identifies the following problems:

CVE-2009-0386

Tobias Klein discovered a buffer overflow in the quicktime stream
demuxer (qtdemux), which could potentially lead to the execution of
arbitrary code via crafted .mov files.

CVE-2009-0387

Tobias Klein discovered an array index error in the quicktime stream
demuxer (qtdemux), which could potentially lead to the execution of
arbitrary code via crafted .mov files.

CVE-2009-0397

Tobias Klein discovered a buffer overflow in the quicktime stream
demuxer (qtdemux) similar to the issue reported in CVE-2009-0386, which
could also lead to the execution of arbitrary code via crafted .mov
files.


For the stable distribution (lenny), these problems have been fixed in
version 0.10.8-4.1~lenny1 of gst-plugins-good0.10, since the affected
plugin has been moved there. The fix was already included in the lenny
release.

For the oldstable distribution (etch), these problems have been fixed in
version 0.10.3-3.1+etch1.

For the unstable distribution (sid) and the testing distribution
(squeeze), these problems have been fixed in version 0.10.8-4.1 of
gst-plugins-good0.10.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201729-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 1729-1 (gst-plugins-bad0.10)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"gstreamer0.10-plugins-bad", ver:"0.10.3-3.1+etch1", rls:"DEB4.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
