# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1736-1 (mahara)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(63576);
 script_cve_id("CVE-2009-0660");
 script_version ("$");
 name = "Debian Security Advisory DSA 1736-1 (mahara)";
 script_name(name);

 desc = "The remote host is missing an update to mahara
announced via advisory DSA 1736-1.

It was discovered that mahara, an electronic portfolio, weblog, and
resume builder, is prone to cross-site scripting attacks, which allows
the injection of arbitrary Java or HTML code.

For the stable distribution (lenny), this problem has been fixed in
version 1.0.4-4+lenny1.

The oldstable distribution (etch) does not contain mahara.

For the testing distribution (squeeze) and the unstable distribution
(sid), this problem will be fixed soon.


We recommend that you upgrade your mahara package.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201736-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 1736-1 (mahara)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"mahara", ver:"1.0.4-4+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"mahara-apache2", ver:"1.0.4-4+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
