# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1781-1 (ffmpeg-debian)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(63934);
 script_cve_id("CVE-2009-0385", "CVE-2008-3162");
 script_version ("$");
 name = "Debian Security Advisory DSA 1781-1 (ffmpeg-debian)";
 script_name(name);

 desc = "The remote host is missing an update to ffmpeg-debian
announced via advisory DSA 1781-1.


Several vulnerabilities have been discovered in ffmpeg, a multimedia
player, server and encoder. The Common Vulnerabilities and Exposures
project identifies the following problems:


CVE-2009-0385

It was discovered that watching a malformed 4X movie file could lead to
the execution of arbitrary code.

CVE-2008-3162

It was discovered that using a crafted STR file can lead to the
execution of arbitrary code.


For the oldstable distribution (etch), these problems have been fixed
in version 0.cvs20060823-8+etch1.

For the stable distribution (lenny), these problems have been fixed in
version 0.svn20080206-17+lenny1.

For the testing distribution (squeeze) and the unstable distribution
(sid), these problems have been fixed in version 0.svn20080206-16.


We recommend that you upgrade your ffmpeg-debian packages.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201781-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 1781-1 (ffmpeg-debian)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"libavcodec0d", ver:"0.cvs20060823-8+etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libavformat-dev", ver:"0.cvs20060823-8+etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libpostproc0d", ver:"0.cvs20060823-8+etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libavcodec-dev", ver:"0.cvs20060823-8+etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"ffmpeg", ver:"0.cvs20060823-8+etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libavformat0d", ver:"0.cvs20060823-8+etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libpostproc-dev", ver:"0.cvs20060823-8+etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"ffmpeg-doc", ver:"0.svn20080206-17+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"ffmpeg-dbg", ver:"0.svn20080206-17+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libavdevice52", ver:"0.svn20080206-17+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"ffmpeg", ver:"0.svn20080206-17+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libavformat-dev", ver:"0.svn20080206-17+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libpostproc51", ver:"0.svn20080206-17+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libpostproc-dev", ver:"0.svn20080206-17+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libswscale-dev", ver:"0.svn20080206-17+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libswscale0", ver:"0.svn20080206-17+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libavcodec51", ver:"0.svn20080206-17+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libavutil-dev", ver:"0.svn20080206-17+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libavdevice-dev", ver:"0.svn20080206-17+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libavformat52", ver:"0.svn20080206-17+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libavcodec-dev", ver:"0.svn20080206-17+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libavutil49", ver:"0.svn20080206-17+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
