# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1797-1 (xulrunner)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(63962);
 script_cve_id("CVE-2009-0652", "CVE-2009-1302", "CVE-2009-1303", "CVE-2009-1304", "CVE-2009-1305", "CVE-2009-1306", "CVE-2009-1307", "CVE-2009-1308", "CVE-2009-1309", "CVE-2009-1311", "CVE-2009-1312");
 script_version ("$");
 name = "Debian Security Advisory DSA 1797-1 (xulrunner)";
 script_name(name);

 desc = "The remote host is missing an update to xulrunner
announced via advisory DSA 1797-1.

Several remote vulnerabilities have been discovered in Xulrunner, a
runtime environment for XUL applications, such as the Iceweasel web
browser. The Common Vulnerabilities and Exposures project identifies
the following problems:

CVE-2009-0652

Moxie Marlinspike discovered that Unicode box drawing characters inside of
internationalised domain names could be used for phishing attacks.

CVE-2009-1302

Olli Pettay, Martijn Wargers, Mats Palmgren, Oleg Romashin, Jesse Ruderman
and Gary Kwong reported crashes in the in the layout engine, which might
allow the execution of arbitrary code.

CVE-2009-1303

Olli Pettay, Martijn Wargers, Mats Palmgren, Oleg Romashin, Jesse Ruderman
and Gary Kwong reported crashes in the in the layout engine, which might
allow the execution of arbitrary code.

CVE-2009-1304

Igor Bukanov and Bob Clary discovered crashes in the Javascript engine,
which might allow the execution of arbitrary code.

CVE-2009-1305

Igor Bukanov and Bob Clary discovered crashes in the Javascript engine,
which might allow the execution of arbitrary code.

CVE-2009-1306

Daniel Veditz discovered that the Content-Disposition: header is ignored
within the jar: URI scheme.

CVE-2009-1307

Gregory Fleischer discovered that the same-origin policy for Flash files
is inproperly enforced for files loaded through the view-source scheme,
which may result in bypass of cross-domain policy restrictions.

CVE-2009-1308

Cefn Hoile discovered that sites, which allow the embedding of third-party
stylesheets are vulnerable to cross-site scripting attacks through XBL
bindings.

CVE-2009-1309

moz_bug_r_a4 discovered bypasses of the same-origin policy in the
XMLHttpRequest Javascript API and the XPCNativeWrapper.

CVE-2009-1311

Paolo Amadini discovered that incorrect handling of POST data when
saving a web site with an embedded frame may lead to information disclosure.

CVE-2009-1312

It was discovered that Iceweasel allows Refresh: headers to redirect
to Javascript URIs, resulting in cross-site scripting.

For the stable distribution (lenny), these problems have been fixed
in version 1.9.0.9-0lenny2.

As indicated in the Etch release notes, security support for the
Mozilla products in the oldstable distribution needed to be stopped
before the end of the regular Etch security maintenance life cycle.
You are strongly encouraged to upgrade to stable or switch to a still
supported browser.

For the unstable distribution (sid), these problems have been fixed in
version 1.9.0.9-1.

We recommend that you upgrade your xulrunner packages.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201797-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 1797-1 (xulrunner)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"libmozillainterfaces-java", ver:"1.9.0.9-0lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"xulrunner-1.9-gnome-support", ver:"1.9.0.9-0lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"xulrunner-1.9-dbg", ver:"1.9.0.9-0lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libmozjs-dev", ver:"1.9.0.9-0lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"xulrunner-1.9", ver:"1.9.0.9-0lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libmozjs1d", ver:"1.9.0.9-0lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"xulrunner-dev", ver:"1.9.0.9-0lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"python-xpcom", ver:"1.9.0.9-0lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libmozjs1d-dbg", ver:"1.9.0.9-0lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"spidermonkey-bin", ver:"1.9.0.9-0lenny2", rls:"DEB5.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
