# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1804-1 (ipsec-tools)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(64036);
 script_cve_id("CVE-2009-1574", "CVE-2009-1632");
 script_version ("$");
 name = "Debian Security Advisory DSA 1804-1 (ipsec-tools)";
 script_name(name);

 desc = "The remote host is missing an update to ipsec-tools
announced via advisory DSA 1804-1.

Several remote vulnerabilities have been discovered in racoon, the Internet Key
Exchange daemon of ipsec-tools.  The The Common Vulnerabilities and Exposures
project identified the following problems:

Neil Kettle discovered a NULL pointer dereference on crafted fragmented packets
that contain no payload.  This results in the daemon crashing which can be used
for denial of service attacks (CVE-2009-1574).

Various memory leaks in the X.509 certificate authentication handling and the
NAT-Traversal keepalive implementation can result in memory exhaustion and
thus denial of service (CVE-2009-1632).


For the oldstable distribution (etch), this problem has been fixed in
version 0.6.6-3.1etch3.

For the stable distribution (lenny), this problem has been fixed in
version 0.7.1-1.3+lenny2.

For the testing distribution (squeeze), this problem will be fixed soon.

For the unstable distribution (sid), this problem has been fixed in
version 1:0.7.1-1.5.


We recommend that you upgrade your ipsec-tools packages.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201804-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 1804-1 (ipsec-tools)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"racoon", ver:"0.6.6-3.1etch3", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"ipsec-tools", ver:"0.6.6-3.1etch3", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"racoon", ver:"0.7.1-1.3+lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"ipsec-tools", ver:"0.7.1-1.3+lenny2", rls:"DEB5.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
