# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 181-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(53433);
 script_bugtraq_id(6029);
 script_cve_id("CVE-2002-1157");
 script_version ("$");
 name = "Debian Security Advisory DSA 181-1 (libapache-mod-ssl)";
 script_name(name);

 desc = "The remote host is missing an update to libapache-mod-ssl
announced via advisory DSA 181-1.

Joe Orton discovered a cross site scripting problem in mod_ssl, an
Apache module that adds Strong cryptography (i.e. HTTPS support) to
the webserver.  The module will return the server name unescaped in
the response to an HTTP request on an SSL port.

Like the other recent Apache XSS bugs, this only affects servers using
a combination of UseCanonicalName off (default in the Debian package
of Apache) and wildcard DNS.  This is very unlikely to happen, though.
Apache 2.0/mod_ssl is not vulnerable since it already escapes this
HTML.

With this setting turned on, whenever Apache needs to construct a
self-referencing URL (a URL that refers back to the server the
response is coming from) it will use ServerName and Port to form a
canonical name.  With this setting off, Apache will use the
hostname:port that the client supplied, when possible.  This also
affects SERVER_NAME and SERVER_PORT in CGI scripts.

This problem has been fixed in version 2.8.9-2.1 for the current
stable distribution (woody), in version 2.4.10-1.3.9-1potato4 for the
old stable distribution (potato) and version 2.8.9-2.3 for the
unstable distribution (sid).

We recommend that you upgrade your libapache-mod-ssl package.


Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20181-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 181-1 (libapache-mod-ssl)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"libapache-mod-ssl-doc", ver:"2.4.10-1.3.9-1potato4", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libapache-mod-ssl", ver:"2.4.10-1.3.9-1potato4", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libapache-mod-ssl-doc", ver:"2.8.9-2.1", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libapache-mod-ssl", ver:"2.8.9-2.1", rls:"DEB3.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
