# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1841-2 (git-core)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2010 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(66803);
 script_cve_id("CVE-2009-2108");
 script_version ("$Revision$");
 script_name("Debian Security Advisory DSA 1841-2 (git-core)");

 desc = "The remote host is missing an update to git-core
announced via advisory DSA 1841-2.

A bug in git-core caused the security update in DSA 1841 to fail to
build on a number of architectures Debian supports. This update corrects
the bug and releases builds for all supported architectures. The original
advisory is quoted in full below for reference.

It was discovered that git-daemon which is part of git-core, a popular
distributed revision control system, is vulnerable to denial of service
attacks caused by a programming mistake in handling requests containing
extra unrecognized arguments which results in an infinite loop. While
this is no problem for the daemon itself as every request will spawn a
new git-daemon instance, this still results in a very high CPU consumption
and might lead to denial of service conditions.

For the oldstable distribution (etch), this problem has been fixed in
version 1.4.4.4-4+etch4.

For the stable distribution (lenny), this problem has been fixed in
version 1.5.6.5-3+lenny3.

For the testing distribution (squeeze), this problem has been fixed in
version 1:1.6.3.3-1.

For the unstable distribution (sid), this problem has been fixed in
version 1:1.6.3.3-1.

We recommend that you upgrade your git-core packages.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201841-2

Risk factor : High";

 script_description(desc);

 script_summary("Debian Security Advisory DSA 1841-2 (git-core)");

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2010 E-Soft Inc. http://www.securityspace.com");
 script_family("Debian Local Security Checks");
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"gitk", ver:"1.4.4.4-4+etch4", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"git-cvs", ver:"1.4.4.4-4+etch4", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"git-svn", ver:"1.4.4.4-4+etch4", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"git-email", ver:"1.4.4.4-4+etch4", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"git-arch", ver:"1.4.4.4-4+etch4", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"gitweb", ver:"1.4.4.4-4+etch4", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"git-daemon-run", ver:"1.4.4.4-4+etch4", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"git-doc", ver:"1.4.4.4-4+etch4", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"git-core", ver:"1.4.4.4-4+etch4", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"gitweb", ver:"1.5.6.5-3+lenny3", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"git-daemon-run", ver:"1.5.6.5-3+lenny3", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"git-arch", ver:"1.5.6.5-3+lenny3", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"git-cvs", ver:"1.5.6.5-3+lenny3", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"gitk", ver:"1.5.6.5-3+lenny3", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"git-gui", ver:"1.5.6.5-3+lenny3", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"git-svn", ver:"1.5.6.5-3+lenny3", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"git-doc", ver:"1.5.6.5-3+lenny3", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"git-email", ver:"1.5.6.5-3+lenny3", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"git-core", ver:"1.5.6.5-3+lenny3", rls:"DEB5.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
