# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1843-2 (squid3)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(64636);
 script_cve_id("CVE-2009-2622", "CVE-2009-2621");
 script_version ("$Revision$");
 script_name("Debian Security Advisory DSA 1843-2 (squid3)");

 desc = "The remote host is missing an update to squid3
announced via advisory DSA 1843-2.

It was discovered that squid3, a high-performance proxy caching server for
web clients, is prone to several denial of service attacks.  Due to incorrect
bounds checking and insufficient validation while processing response and
request data an attacker is able to crash the squid daemon via crafted
requests or responses.

This update to DSA-1843-1 includes updated upstream patches which add
checks for a corner-case in which an incomplete server reply could
also lead to denial of service conditions as well as more debugging
information.


The squid package in the oldstable distribution (etch) is not affected
by this problem.

For the stable distribution (lenny), this problem has been fixed in
version 3.0.STABLE8-3+lenny2.

For the testing distribution (squeeze), this problem will be fixed soon.

For the unstable distribution (sid), this problem has been fixed in
version 3.0.STABLE18-1.


We recommend that you upgrade your squid3 packages.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201843-2

Risk factor : High";

 script_description(desc);

 script_summary("Debian Security Advisory DSA 1843-2 (squid3)");

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 script_family("Debian Local Security Checks");
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"squid3-common", ver:"3.0.STABLE8-3+lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"squid3-cgi", ver:"3.0.STABLE8-3+lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"squid3", ver:"3.0.STABLE8-3+lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"squidclient", ver:"3.0.STABLE8-3+lenny2", rls:"DEB5.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
