# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1847-1 (bind9)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(64558);
 script_cve_id("CVE-2009-0696");
 script_version ("$");
 script_name("Debian Security Advisory DSA 1847-1 (bind9)");

 desc = "The remote host is missing an update to bind9
announced via advisory DSA 1847-1.

It was discovered that the BIND DNS server terminates when processing a
specially crafted dynamic DNS update.  This vulnerability affects all
BIND servers which serve at least one DNS zone authoritatively, as a
master, even if dynamic updates are not enabled.  The default Debian
configuration for resolvers includes several authoritative zones, too,
so resolvers are also affected by this issue unless these zones have
been removed.

For the old stable distribution (etch), this problem has been fixed in
version 9.3.4-2etch5.

For the stable distribution (lenny), this problem has been fixed in
version 9.5.1.dfsg.P3-1.

For the unstable distribution (sid), this problem has been fixed in
version 1:9.6.1.dfsg.P1-1.

We recommend that you upgrade your bind9 packages.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201847-1

Risk factor : High";

 script_description(desc);

 script_summary("Debian Security Advisory DSA 1847-1 (bind9)");

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 script_family("Debian Local Security Checks");
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"bind9-doc", ver:"9.3.4-2etch5", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libisccc0", ver:"9.3.4-2etch5", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libdns22", ver:"9.3.4-2etch5", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libbind9-0", ver:"9.3.4-2etch5", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"bind9-host", ver:"9.3.4-2etch5", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libisc11", ver:"9.3.4-2etch5", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"liblwres9", ver:"9.3.4-2etch5", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libisccfg1", ver:"9.3.4-2etch5", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"lwresd", ver:"9.3.4-2etch5", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"bind9", ver:"9.3.4-2etch5", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libbind-dev", ver:"9.3.4-2etch5", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"dnsutils", ver:"9.3.4-2etch5", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"bind9-doc", ver:"9.5.1.dfsg.P3-1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libisc45", ver:"9.5.1.dfsg.P3-1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"bind9", ver:"9.5.1.dfsg.P3-1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libbind9-40", ver:"9.5.1.dfsg.P3-1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"dnsutils", ver:"9.5.1.dfsg.P3-1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libisccfg40", ver:"9.5.1.dfsg.P3-1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libisccc40", ver:"9.5.1.dfsg.P3-1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"bind9utils", ver:"9.5.1.dfsg.P3-1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"bind9-host", ver:"9.5.1.dfsg.P3-1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libdns45", ver:"9.5.1.dfsg.P3-1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"liblwres40", ver:"9.5.1.dfsg.P3-1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"lwresd", ver:"9.5.1.dfsg.P3-1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libbind-dev", ver:"9.5.1.dfsg.P3-1", rls:"DEB5.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
