# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1858-1 (imagemagick)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(64637);
 script_cve_id("CVE-2007-1667", "CVE-2007-1797", "CVE-2007-4985", "CVE-2007-4986", "CVE-2007-4987", "CVE-2007-4988", "CVE-2008-1096", "CVE-2008-1097", "CVE-2009-1882");
 script_version ("$Revision$");
 script_name("Debian Security Advisory DSA 1858-1 (imagemagick)");

 desc = "The remote host is missing an update to imagemagick
announced via advisory DSA 1858-1.

Several vulnerabilities have been discovered in the imagemagick image
manipulation programs which can lead to the execution of arbitrary code,
exposure of sensitive information or cause DoS. The Common Vulnerabilities
and Exposures project identifies the following problems:

CVE-2007-1667

Multiple integer overflows in XInitImage function in xwd.c for
ImageMagick, allow user-assisted remote attackers to cause a denial of
service (crash) or obtain sensitive information via crafted images with
large or negative values that trigger a buffer overflow. It only affects
the oldstable distribution (etch).

CVE-2007-1797

Multiple integer overflows allow remote attackers to execute arbitrary
code via a crafted DCM image, or the colors or comments field in a
crafted XWD image. It only affects the oldstable distribution (etch).

CVE-2007-4985

A crafted image file can trigger an infinite loop in the ReadDCMImage
function or in the ReadXCFImage function. It only affects the oldstable
distribution (etch).

CVE-2007-4986

Multiple integer overflows allow context-dependent attackers to execute
arbitrary code via a crafted .dcm, .dib, .xbm, .xcf, or .xwd image file,
which triggers a heap-based buffer overflow. It only affects the
oldstable distribution (etch).

CVE-2007-4987

Off-by-one error allows context-dependent attackers to execute arbitrary
code via a crafted image file, which triggers the writing of a '\0'
character to an out-of-bounds address. It affects only the oldstable
distribution (etch).

CVE-2007-4988

A sign extension error allows context-dependent attackers to execute
arbitrary code via a crafted width value in an image file, which
triggers an integer overflow and a heap-based buffer overflow. It
affects only the oldstable distribution (etch).

CVE-2008-1096

The load_tile function in the XCF coder allows user-assisted remote
attackers to cause a denial of service or possibly execute arbitrary
code via a crafted .xcf file that triggers an out-of-bounds heap write.
It affects only to oldstable (etch).

CVE-2008-1097

Heap-based buffer overflow in the PCX coder allows user-assisted remote
attackers to cause a denial of service or possibly execute arbitrary
code via a crafted .pcx file that triggers incorrect memory allocation
for the scanline array, leading to memory corruption. It affects only to
oldstable (etch).

CVE-2009-1882

Integer overflow allows remote attackers to cause a denial of service
(crash) and possibly execute arbitrary code via a crafted TIFF file,
which triggers a buffer overflow.

For the old stable distribution (etch), these problems have been fixed in
version 7:6.2.4.5.dfsg1-0.15+etch1.

For the stable distribution (lenny), these problems have been fixed in
version 7:6.3.7.9.dfsg2-1~lenny3.

For the upcoming stable distribution (squeeze) and the unstable
distribution (sid), these problems have been fixed in version
7:6.5.1.0-1.1.

We recommend that you upgrade your imagemagick packages.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201858-1

Risk factor : High";

 script_description(desc);

 script_summary("Debian Security Advisory DSA 1858-1 (imagemagick)");

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 script_family("Debian Local Security Checks");
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"libmagick++9c2a", ver:"6.2.4.5.dfsg1-0.15+etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libmagick9-dev", ver:"6.2.4.5.dfsg1-0.15+etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"imagemagick", ver:"6.2.4.5.dfsg1-0.15+etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"perlmagick", ver:"6.2.4.5.dfsg1-0.15+etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libmagick++9-dev", ver:"6.2.4.5.dfsg1-0.15+etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libmagick9", ver:"6.2.4.5.dfsg1-0.15+etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libmagick++10", ver:"6.3.7.9.dfsg2-1~lenny3", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libmagick9-dev", ver:"6.3.7.9.dfsg2-1~lenny3", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libmagick10", ver:"6.3.7.9.dfsg2-1~lenny3", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"imagemagick", ver:"6.3.7.9.dfsg2-1~lenny3", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libmagick++9-dev", ver:"6.3.7.9.dfsg2-1~lenny3", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"perlmagick", ver:"6.3.7.9.dfsg2-1~lenny3", rls:"DEB5.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
