# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 185-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(53435);
 script_version ("$");
 name = "Debian Security Advisory DSA 185-1 (heimdal)";
 script_name(name);

 desc = "The remote host is missing an update to heimdal
announced via advisory DSA 185-1.

A stack buffer overflow in the kadm_ser_wrap_in function in the
Kerberos v4 administration server was discovered, which is provided by
Heimdal as well.  A working exploit for this kadmind bug is already
circulating, hence it is considered serious.  The roken library also
contains a vulnerability which could lead to another root exploit.

These problems have been fixed in version 0.4e-7.woody.5 for the
current stable distribution (woody), in version 0.2l-7.6 for the old
stable distribution (potato) and in version 0.4e-22 for the unstable
distribution (sid).

We recommend that you upgrade your heimdal packages immediately.


Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20185-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 185-1 (heimdal)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"heimdal-docs", ver:"0.2l-7.6", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"heimdal-clients", ver:"0.2l-7.6", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"heimdal-clients-x", ver:"0.2l-7.6", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"heimdal-dev", ver:"0.2l-7.6", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"heimdal-kdc", ver:"0.2l-7.6", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"heimdal-lib", ver:"0.2l-7.6", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"heimdal-servers", ver:"0.2l-7.6", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"heimdal-servers-x", ver:"0.2l-7.6", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"heimdal-docs", ver:"0.4e-7.woody.5", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"heimdal-lib", ver:"0.4e-7.woody.5", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"heimdal-clients", ver:"0.4e-7.woody.5", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"heimdal-clients-x", ver:"0.4e-7.woody.5", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"heimdal-dev", ver:"0.4e-7.woody.5", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"heimdal-kdc", ver:"0.4e-7.woody.5", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"heimdal-servers", ver:"0.4e-7.woody.5", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"heimdal-servers-x", ver:"0.4e-7.woody.5", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libasn1-5-heimdal", ver:"0.4e-7.woody.5", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libcomerr1-heimdal", ver:"0.4e-7.woody.5", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libgssapi1-heimdal", ver:"0.4e-7.woody.5", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libhdb7-heimdal", ver:"0.4e-7.woody.5", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libkadm5clnt4-heimdal", ver:"0.4e-7.woody.5", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libkadm5srv7-heimdal", ver:"0.4e-7.woody.5", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libkafs0-heimdal", ver:"0.4e-7.woody.5", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libkrb5-17-heimdal", ver:"0.4e-7.woody.5", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libotp0-heimdal", ver:"0.4e-7.woody.5", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libroken9-heimdal", ver:"0.4e-7.woody.5", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libsl0-heimdal", ver:"0.4e-7.woody.5", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libss0-heimdal", ver:"0.4e-7.woody.5", rls:"DEB3.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
