# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1876-1 (dnsmasq)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(64819);
 script_cve_id("CVE-2009-2957", "CVE-2009-2958");
 script_version ("$");
 script_name("Debian Security Advisory DSA 1876-1 (dnsmasq)");

 desc = "The remote host is missing an update to dnsmasq
announced via advisory DSA 1876-1.

Several remote vulnerabilities have been discovered in the TFTP
component of dnsmasq.  The Common Vulnerabilities and Exposures
project identifies the following problems:

CVE-2009-2957
A buffer overflow in TFTP processing may enable arbitrary code
execution to attackers which are permitted to use the TFTP service.

CVE-2009-2958
Malicious TFTP clients may crash dnsmasq, leading to denial of
service.

The old stable distribution is not affected by these problems.

For the stable distribution (lenny), these problems have been fixed in
version 2.45-1+lenny1.

For the unstable distribution (sid), these problems have been fixed in
version 2.50-1.

We recommend that you upgrade your dnsmasq packages.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201876-1

Risk factor : High";

 script_description(desc);

 script_summary("Debian Security Advisory DSA 1876-1 (dnsmasq)");

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 script_family("Debian Local Security Checks");
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"dnsmasq", ver:"2.45-1+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"dnsmasq-base", ver:"2.45-1+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
