# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1889-1 (icu)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(64921);
 script_cve_id("CVE-2009-0153");
 script_version ("$");
 script_name("Debian Security Advisory DSA 1889-1 (icu)");

 desc = "The remote host is missing an update to icu
announced via advisory DSA 1889-1.

It was discovered that the ICU unicode library performed incorrect
processing of invalid multibyte sequences, resulting in potential
bypass of security mechanisms.

For the old stable distribution (etch), this problem has been fixed in
version 3.6-2etch3.

For the stable distribution (lenny), this problem has been fixed in
version 3.8.1-3+lenny2.

For the unstable distribution (sid), this problem has been fixed in
version 4.0.1-1.

We recommend that you upgrade your icu packages.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201889-1

Risk factor : High";

 script_description(desc);

 script_summary("Debian Security Advisory DSA 1889-1 (icu)");

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 script_family("Debian Local Security Checks");
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"icu-doc", ver:"3.6-2etch3", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libicu36", ver:"3.6-2etch3", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libicu36-dev", ver:"3.6-2etch3", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"icu-doc", ver:"3.8.1-3+lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libicu38", ver:"3.8.1-3+lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libicu-dev", ver:"3.8.1-3+lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libicu38-dbg", ver:"3.8.1-3+lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"lib32icu38", ver:"3.8.1-3+lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"lib32icu-dev", ver:"3.8.1-3+lenny2", rls:"DEB5.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
