# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1892-1 (dovecot)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(64978);
 script_cve_id("CVE-2009-2632", "CVE-2009-3235");
 script_version ("$");
 script_name("Debian Security Advisory DSA 1892-1 (dovecot)");

 desc = "The remote host is missing an update to dovecot
announced via advisory DSA 1892-1.

It was discovered that the SIEVE component of dovecot, a mail server
that supports mbox and maildir mailboxes, is vulnerable to a buffer
overflow when processing SIEVE scripts. This can be used to elevate
privileges to the dovecot system user.  An attacker who is able to
install SIEVE scripts executed by the server is therefore able to read
and modify arbitrary email messages on the system.


For the oldstable distribution (etch), this problem has been fixed in version
1.0.rc15-2etch5.

For the stable distribution (lenny), this problem has been fixed in version
1:1.0.15-2.3+lenny1.

For the testing distribution (squeeze) and the unstable distribution
(sid), this problem has been fixed in version 1:1.2.1-1.


We recommend that you upgrade your dovecot packages.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201892-1

Risk factor : High";

 script_description(desc);

 script_summary("Debian Security Advisory DSA 1892-1 (dovecot)");

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 script_family("Debian Local Security Checks");
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"dovecot-pop3d", ver:"1.0.rc15-2etch5", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"dovecot-imapd", ver:"1.0.rc15-2etch5", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"dovecot-common", ver:"1.0.rc15-2etch5", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"dovecot-dev", ver:"1.0.15-2.3+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"dovecot-pop3d", ver:"1.0.15-2.3+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"dovecot-common", ver:"1.0.15-2.3+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"dovecot-imapd", ver:"1.0.15-2.3+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
