# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1898-1 (openswan)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(65004);
 script_cve_id("CVE-2009-2185");
 script_version ("$");
 script_name("Debian Security Advisory DSA 1898-1 (openswan)");

 desc = "The remote host is missing an update to openswan
announced via advisory DSA 1898-1.

It was discovered that the pluto daemon in the openswan, an
implementation of IPSEC and IKE, could crash when processing a crafted
X.509 certificate.

For the old stable distribution (etch), this problem has been fixed in
version 2.4.6+dfsg.2-1.1+etch2.

For the stable distribution (lenny), this problem has been fixed in
version 2.4.12+dfsg-1.3+lenny2.

For the unstable distribution (sid), this problem has been fixed in
version 2.6.22+dfsg-1.

We recommend that you upgrade your openswan package.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201898-1

Risk factor : High";

 script_description(desc);

 script_summary("Debian Security Advisory DSA 1898-1 (openswan)");

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 script_family("Debian Local Security Checks");
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"openswan-modules-source", ver:"2.4.6+dfsg.2-1.1+etch2", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-patch-openswan", ver:"2.4.6+dfsg.2-1.1+etch2", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"openswan", ver:"2.4.6+dfsg.2-1.1+etch2", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-patch-openswan", ver:"2.4.12+dfsg-1.3+lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"openswan-modules-source", ver:"2.4.12+dfsg-1.3+lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"openswan", ver:"2.4.12+dfsg-1.3+lenny2", rls:"DEB5.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
