# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1930-1 (drupal6)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(66210);
 script_cve_id("CVE-2009-2372", "CVE-2009-2373", "CVE-2009-2374");
 script_version ("$Revision$");
 script_name("Debian Security Advisory DSA 1930-1 (drupal6)");

 desc = "The remote host is missing an update to drupal6
announced via advisory DSA 1930-1.


Several vulnerabilities have been found in drupal6, a fully-featured
content management framework. The Common Vulnerabilities and Exposures
project identifies the following problems:

CVE-2009-2372

Gerhard Killesreiter discovered a flaw in the way user signatures are
handled. It is possible for a user to inject arbitrary code via a
crafted user signature. (SA-CORE-2009-007)

CVE-2009-2373

Mark Piper, Sven Herrmann and Brandon Knight discovered a cross-site
scripting issue in the forum module, which could be exploited via the
tid parameter. (SA-CORE-2009-007)

CVE-2009-2374

Sumit Datta discovered that certain drupal6 pages leak sensible
information such as user credentials. (SA-CORE-2009-007)


Several design flaws in the OpenID module have been fixed, which could
lead to cross-site request forgeries or privilege escalations. Also, the
file upload function does not process all extensions properly leading
to the possible execution of arbitrary code.
(SA-CORE-2009-008)


For the stable distribution (lenny), these problems have been fixed in
version 6.6-3lenny3.

The oldstable distribution (etch) does not contain drupal6.

For the testing distribution (squeeze) and the unstable distribution
(sid), these problems have been fixed in version 6.14-1.


We recommend that you upgrade your drupal6 packages.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201930-1

Risk factor : High";

 script_description(desc);

 script_summary("Debian Security Advisory DSA 1930-1 (drupal6)");

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 script_family("Debian Local Security Checks");
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"drupal6", ver:"6.6-3lenny3", rls:"DEB5.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
