# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1931-1 (nspr)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(66211);
 script_cve_id("CVE-2009-1563", "CVE-2009-2463");
 script_version ("$Revision$");
 script_name("Debian Security Advisory DSA 1931-1 (nspr)");

 desc = "The remote host is missing an update to nspr
announced via advisory DSA 1931-1.

Several vulnerabilities have been discovered in the NetScape Portable
Runtime Library, which may lead to the execution of arbitrary code. The
Common Vulnerabilities and Exposures project identifies the following
problems:

CVE-2009-1563

A programming error in the string handling code may lead to the
execution of arbitrary code.

CVE-2009-2463

An integer overflow in the Base64 decoding functions may lead to
the execution of arbitrary code.

The old stable distribution (etch) doesn't contain nspr.

For the stable distribution (lenny), these problems have been fixed in
version 4.7.1-5.

For the unstable distribution (sid) these problems have been fixed in
version 4.8.2-1.

We recommend that you upgrade your NSPR packages.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201931-1

Risk factor : High";

 script_description(desc);

 script_summary("Debian Security Advisory DSA 1931-1 (nspr)");

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 script_family("Debian Local Security Checks");
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"libnspr4-0d", ver:"4.7.1-5", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libnspr4-0d-dbg", ver:"4.7.1-5", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libnspr4-dev", ver:"4.7.1-5", rls:"DEB5.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
