# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1941-1 (poppler)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(66332);
 script_cve_id("CVE-2009-0755", "CVE-2009-3903", "CVE-2009-3904", "CVE-2009-3905", "CVE-2009-3906", "CVE-2009-3907", "CVE-2009-3908", "CVE-2009-3909", "CVE-2009-3938");
 script_version ("$Revision$");
 script_name("Debian Security Advisory DSA 1941-1 (poppler)");

 desc = "The remote host is missing an update to poppler
announced via advisory DSA 1941-1.

Several integer overflows, buffer overflows and memory allocation
errors were discovered in the Poppler PDF rendering library, which may
lead to denial of service or the execution of arbitrary code if a user
is tricked into opening a malformed PDF document.

For the stable distribution (lenny), these problems have been fixed in
version 0.8.7-3.

An update for the old stable distribution (etch) will be issued soon as
version 0.4.5-5.1etch4.

For the unstable distribution (sid), these problems will be fixed soon.

We recommend that you upgrade your poppler packages.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201941-1

Risk factor : High";

 script_description(desc);

 script_summary("Debian Security Advisory DSA 1941-1 (poppler)");

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 script_family("Debian Local Security Checks");
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"libpoppler-dev", ver:"0.8.7-3", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libpoppler-qt-dev", ver:"0.8.7-3", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"poppler-utils", ver:"0.8.7-3", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libpoppler-qt2", ver:"0.8.7-3", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libpoppler-glib3", ver:"0.8.7-3", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libpoppler-qt4-dev", ver:"0.8.7-3", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libpoppler-qt4-3", ver:"0.8.7-3", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libpoppler3", ver:"0.8.7-3", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libpoppler-glib-dev", ver:"0.8.7-3", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"poppler-dbg", ver:"0.8.7-3", rls:"DEB5.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
