# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1944-1 (request-tracker3.4/request-tracker3.6)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(66456);
 script_cve_id("CVE-2009-3585");
 script_version ("$Revision$");
 script_name("Debian Security Advisory DSA 1944-1 (request-tracker3.4/request-tracker3.6)");

 desc = "The remote host is missing an update to request-tracker3.4/request-tracker3.6
announced via advisory DSA 1944-1.


Mikal Gule discovered that request-tracker, an extensible trouble-ticket
tracking system, is prone to an attack, where an attacker with access
to the same domain can hijack a user's RT session.


For the stable distribution (lenny), this problem has been fixed in
version 3.6.7-5+lenny3.

For the oldstable distribution (etch), this problem has been fixed in
version 3.6.1-4+etch1 of request-tracker3.6 and version 3.4.5-2+etch1
of request-tracker3.4.

For the testing distribution (squeeze), this problem will be fixed soon.

For the unstable distribution (sid), this problem has been fixed in
version 3.6.9-2.

We recommend that you upgrade your request-tracker packages.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201944-1

Risk factor : High";

 script_description(desc);

 script_summary("Debian Security Advisory DSA 1944-1 (request-tracker3.4/request-tracker3.6)");

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 script_family("Debian Local Security Checks");
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"rt3.6-apache2", ver:"3.6.1-4+etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"rt3.6-apache", ver:"3.6.1-4+etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"rt3.4-clients", ver:"3.4.5-2+etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"request-tracker3.4", ver:"3.4.5-2+etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"rt3.4-apache", ver:"3.4.5-2+etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"request-tracker3.6", ver:"3.6.1-4+etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"rt3.6-clients", ver:"3.6.1-4+etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"rt3.4-apache2", ver:"3.4.5-2+etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"rt3.6-db-mysql", ver:"3.6.7-5+lenny3", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"rt3.6-db-sqlite", ver:"3.6.7-5+lenny3", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"rt3.6-apache2", ver:"3.6.7-5+lenny3", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"rt3.6-db-postgresql", ver:"3.6.7-5+lenny3", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"request-tracker3.6", ver:"3.6.7-5+lenny3", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"rt3.6-clients", ver:"3.6.7-5+lenny3", rls:"DEB5.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
