# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1948-1 (ntp)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(66515);
 script_cve_id("CVE-2009-3563");
 script_version ("$Revision$");
 script_name("Debian Security Advisory DSA 1948-1 (ntp)");

 desc = "The remote host is missing an update to ntp
announced via advisory DSA 1948-1.

Robin Park and Dmitri Vinokurov discovered that the daemon component of
the ntp package, a reference implementation of the NTP protocol, is
not properly reacting to certain incoming packets.

An unexpected NTP mode 7 packets (MODE_PRIVATE) with spoofed IP data can lead
ntpd to reply with a mode 7 response to the spoofed address.  This may result
in the service playing packet ping-pong with other ntp servers or even itself
which causes CPU usage and excessive disk use due to logging.  An attacker
can use this to conduct denial of service attacks.


For the oldstable distribution (etch), this problem has been fixed in
version 1:4.2.2.p4+dfsg-2etch4.

For the stable distribution (lenny), this problem has been fixed in
version 1:4.2.4p4+dfsg-8lenny3.

For the testing (squeeze) and unstable (sid) distribution, this problem
will be fixed soon.


We recommend that you upgrade your ntp packages.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201948-1

Risk factor : High";

 script_description(desc);

 script_summary("Debian Security Advisory DSA 1948-1 (ntp)");

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 script_family("Debian Local Security Checks");
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"ntp-refclock", ver:"4.2.2.p4+dfsg-2etch4", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"ntp-simple", ver:"4.2.2.p4+dfsg-2etch4", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"ntp-doc", ver:"4.2.2.p4+dfsg-2etch4", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"ntp", ver:"4.2.2.p4+dfsg-2etch4", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"ntpdate", ver:"4.2.2.p4+dfsg-2etch4", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"ntp-doc", ver:"4.2.4p4+dfsg-8lenny3", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"ntpdate", ver:"4.2.4p4+dfsg-8lenny3", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"ntp", ver:"4.2.4p4+dfsg-8lenny3", rls:"DEB5.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
