# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1978-1 (phpgroupware)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2010 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(66772);
 script_cve_id("CVE-2009-4414", "CVE-2009-4415", "CVE-2009-4416");
 script_version ("$Revision$");
 script_name("Debian Security Advisory DSA 1978-1 (phpgroupware)");

 desc = "The remote host is missing an update to phpgroupware
announced via advisory DSA 1978-1.

Several remote vulnerabilities have been discovered in phpgroupware, a
Web based groupware system written in PHP. The Common Vulnerabilities
and Exposures project identifies the following problems:

CVE-2009-4414

An SQL injection vulnerability was found in the authentication
module.

CVE-2009-4415

Multiple directory traversal vulnerabilities were found in the
addressbook module.

CVE-2009-4416

The authentication module is affected by cross-site scripting.


For the stable distribution (lenny) these problems have been fixed in
version 0.9.16.012+dfsg-8+lenny1.

For the unstable distribution (sid) these problems have been fixed in
version 0.9.16.012+dfsg-9.

We recommend that you upgrade your phpgroupware packages.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201978-1

Risk factor : High";

 script_description(desc);

 script_summary("Debian Security Advisory DSA 1978-1 (phpgroupware)");

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2010 E-Soft Inc. http://www.securityspace.com");
 script_family("Debian Local Security Checks");
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"phpgroupware-0.9.16-email", ver:"0.9.16.012+dfsg-8+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"phpgroupware-0.9.16-core-base", ver:"0.9.16.012+dfsg-8+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"phpgroupware-0.9.16-calendar", ver:"0.9.16.012+dfsg-8+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"phpgroupware-0.9.16-addressbook", ver:"0.9.16.012+dfsg-8+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"phpgroupware", ver:"0.9.16.012+dfsg-8+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"phpgroupware-0.9.16-news-admin", ver:"0.9.16.012+dfsg-8+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"phpgroupware-0.9.16-manual", ver:"0.9.16.012+dfsg-8+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"phpgroupware-0.9.16-filemanager", ver:"0.9.16.012+dfsg-8+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"phpgroupware-0.9.16-phpgwapi", ver:"0.9.16.012+dfsg-8+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"phpgroupware-0.9.16-preferences", ver:"0.9.16.012+dfsg-8+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"phpgroupware-0.9.16", ver:"0.9.16.012+dfsg-8+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"phpgroupware-0.9.16-core", ver:"0.9.16.012+dfsg-8+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"phpgroupware-0.9.16-admin", ver:"0.9.16.012+dfsg-8+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"phpgroupware-0.9.16-notes", ver:"0.9.16.012+dfsg-8+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"phpgroupware-0.9.16-doc", ver:"0.9.16.012+dfsg-8+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"phpgroupware-0.9.16-phpgwapi-doc", ver:"0.9.16.012+dfsg-8+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"phpgroupware-0.9.16-setup", ver:"0.9.16.012+dfsg-8+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"phpgroupware-0.9.16-todo", ver:"0.9.16.012+dfsg-8+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
