# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1993-1 (otrs2)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2010 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(66836);
 script_cve_id("CVE-2010-0438");
 script_version ("$Revision$");
 script_name("Debian Security Advisory DSA 1993-1 (otrs2)");

 desc = "The remote host is missing an update to otrs2
announced via advisory DSA 1993-1.

It was discovered that otrs2, the Open Ticket Request System, does not
properly sanitise input data that is used on SQL queries, which might be
used to inject arbitrary SQL to, for example, escalate privileges on a
system that uses otrs2.

The oldstable distribution (etch) is not affected.

For the stable distribution (lenny), the problem has been fixed in
version 2.2.7-2lenny3.

For the testing distribution (squeeze), the problem will be fixed soon.

For the unstable distribution (sid), the problem has been fixed in
version 2.4.7-1.

We recommend that you upgrade your otrs2 packages.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201993-1

Risk factor : High";

 script_description(desc);

 script_summary("Debian Security Advisory DSA 1993-1 (otrs2)");

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2010 E-Soft Inc. http://www.securityspace.com");
 script_family("Debian Local Security Checks");
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"otrs2", ver:"2.2.7-2lenny3", rls:"DEB5.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
