# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1994-1 (ajaxterm)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2010 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(66837);
 script_cve_id("CVE-2009-1629");
 script_version ("$Revision$");
 script_name("Debian Security Advisory DSA 1994-1 (ajaxterm)");

 desc = "The remote host is missing an update to ajaxterm
announced via advisory DSA 1994-1.

It was discovered that ajaxterm, a web-based terminal, generates weak
and predictable session IDs, which might be used to hijack a session or
cause a denial of service attack on a system that uses ajaxterm.

For the oldstable distribution (etch), the problem has been fixed in
version 0.9-2+etch1.

For the stable distribution (lenny), the problem has been fixed in
version 0.10-2+lenny1.

For the unstable distribution (sid), the problem has been fixed in
version 0.10-5.

We recommend that you upgrade your ajaxterm package.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201994-1

Risk factor : High";

 script_description(desc);

 script_summary("Debian Security Advisory DSA 1994-1 (ajaxterm)");

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2010 E-Soft Inc. http://www.securityspace.com");
 script_family("Debian Local Security Checks");
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"ajaxterm", ver:"0.9-2+etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"ajaxterm", ver:"0.10-2+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
