# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 214-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(53454);
 script_cve_id("CVE-2002-1306");
 script_version ("$");
 name = "Debian Security Advisory DSA 214-1 (kdenetwork)";
 script_name(name);

 desc = "The remote host is missing an update to kdenetwork
announced via advisory DSA 214-1.

Olaf Kirch from SuSE Linux AG discovered another vulnerability in the
klisa package, that provides a LAN information service similar to
Network Neighbourhood.  The lisa daemon contains a buffer overflow
vulnerability which potentially enables any local user, as well any
any remote attacker on the LAN who is able to gain control of the LISa
port (7741 by default), to obtain root privileges.  In addition, a
remote attacker potentially may be able to gain access to a victim's
account by using an rlan:// URL in an HTML page or via another KDE
application.

This problem has been fixed in version 2.2.2-14.5 for the current
stable distribution (woody) and in version 2.2.2-14.20 for the
unstable distribution (sid).  The old stable distribution (potato) is
not affected since it doesn't contain a kdenetwork package.

We recommend that you upgrade your klisa package immediately.


Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20214-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 214-1 (kdenetwork)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"kdict", ver:"2.2.2-14.5", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kit", ver:"2.2.2-14.5", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"klisa", ver:"2.2.2-14.5", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kmail", ver:"2.2.2-14.5", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"knewsticker", ver:"2.2.2-14.5", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"knode", ver:"2.2.2-14.5", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"korn", ver:"2.2.2-14.5", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kppp", ver:"2.2.2-14.5", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"ksirc", ver:"2.2.2-14.5", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"ktalkd", ver:"2.2.2-14.5", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libkdenetwork1", ver:"2.2.2-14.5", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libmimelib-dev", ver:"2.2.2-14.5", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libmimelib1", ver:"2.2.2-14.5", rls:"DEB3.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
