# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 224-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(53720);
 script_cve_id("CVE-2002-1158", "CVE-2002-1159");
 script_bugtraq_id(6351,6354);
 script_version ("$");
 name = "Debian Security Advisory DSA 224-1 (canna)";
 script_name(name);

 desc = "The remote host is missing an update to canna
announced via advisory DSA 224-1.

Several vulnerabilities have been discovered in canna, a Japanese
input system.  The Common Vulnerabilities and Exposures (CVE) project
identified the following vulnerabilities:

* CVE-2002-1158 (BugTraq Id 6351): hsj of Shadow Penguin Security
discovered a heap overflow vulnerability in the irw_through
function in canna server.

* CVE-2002-1159 (BugTraq Id 6354): Shinra Aida of the Canna project
discovered that canna does not properly validate requests, which
allows remote attackers to cause a denial of service or information
leak.

For the current stable distribution (woody) these problems have been
fixed in version 3.5b2-46.2.

For the old stable distribution (potato) these problems have been
fixed in version 3.5b2-25.2.

For the unstable distribution (sid) these problems have been fixed in
version 3.6p1-1.

We recommend that you upgrade your canna packages.


Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20224-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 224-1 (canna)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"canna", ver:"3.5b2-25.2", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"canna-utils", ver:"3.5b2-25.2", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libcanna1g", ver:"3.5b2-25.2", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libcanna1g-dev", ver:"3.5b2-25.2", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"canna", ver:"3.5b2-46.2", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"canna-utils", ver:"3.5b2-46.2", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libcanna1g", ver:"3.5b2-46.2", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libcanna1g-dev", ver:"3.5b2-46.2", rls:"DEB3.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
