# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 232-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(53586);
 script_cve_id("CVE-2002-1366", "CVE-2002-1367", "CVE-2002-1368", "CVE-2002-1369", "CVE-2002-1371", "CVE-2002-1372", "CVE-2002-1383", "CVE-2002-1384");
 script_version ("$");
 name = "Debian Security Advisory DSA 232-1 (cupsys)";
 script_name(name);

 desc = "The remote host is missing an update to cupsys
announced via advisory DSA 232-1.

Multiple vulnerabilities were discovered in the Common Unix Printing
System (CUPS).  Several of these issues represent the potential for a
remote compromise or denial of service.  The Common Vulnerabilities
and Exposures project identifies the following problems:

. CVE-2002-1383: Multiple integer overflows allow a remote attacker
to execute arbitrary code via the CUPSd HTTP interface and the
image handling code in CUPS filters.

. CVE-2002-1366: Race conditions in connection with /etc/cups/certs/
allow local users with lp privileges to create or overwrite
arbitrary files.  This is not present in the potato version.

. CVE-2002-1367: This vulnerabilities allows a remote attacker to add
printers without authentication via a certain UDP packet, which can
then be used to perform unauthorized activities such as stealing
the local root certificate for the administration server via a
'need authorization' page.

. CVE-2002-1368: Negative lengths fed into memcpy() can cause a
denial of service and possibly execute arbitrary code.

. CVE-2002-1369: An unsafe strncat() function call processing the
options string allows a remote attacker to execute arbitrary code
via a buffer overflow.

. CVE-2002-1371: Zero width images allows a remote attacker to
execute arbitrary code via modified chunk headers.

. CVE-2002-1372: CUPS does not properly check the return values of
various file and socket operations, which could allow a remote
attacker to cause a denial of service.

. CVE-2002-1384: The cupsys package contains some code from the xpdf
package, used to convert PDF files for printing, which contains an
exploitable integer overflow bug.  This is not present in the
potato version.

Even though we tried very hard to fix all problems in the packages for
potato as well, the packages may still contain other security related
problems.  Hence, we advise users of potato systems using CUPS to
upgrade to woody soon.

For the current stable distribution (woody), these problems have been fixed
in version 1.1.14-4.3.

For the old stable distribution (potato), these problems have been fixed
in version 1.0.4-12.1.

For the unstable distribution (sid), these problems have been fixed in
version 1.1.18-1.

We recommend that you upgrade your CUPS packages immediately.


Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20232-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 232-1 (cupsys)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"cupsys", ver:"1.0.4-12.1", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"cupsys-bsd", ver:"1.0.4-12.1", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libcupsys1", ver:"1.0.4-12.1", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libcupsys1-dev", ver:"1.0.4-12.1", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"cupsys", ver:"1.1.14-4.3", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"cupsys-bsd", ver:"1.1.14-4.3", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"cupsys-client", ver:"1.1.14-4.3", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"cupsys-pstoraster", ver:"1.1.14-4.3", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libcupsys2", ver:"1.1.14-4.3", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libcupsys2-dev", ver:"1.1.14-4.3", rls:"DEB3.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
