# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 259-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(53590);
 script_version ("$");
 name = "Debian Security Advisory DSA 259-1 (qpopper)";
 script_name(name);

 desc = "The remote host is missing an update to qpopper
announced via advisory DSA 259-1.

Florian Heinz <heinz@cronon-ag.de> posted to the Bugtraq mailing list an
exploit for qpopper based on a bug in the included vsnprintf implementation.
The sample exploit requires a valid user account and password, and overflows a
string in the pop_msg() function to give the user 'mail' group privileges and a
shell on the system. Since the Qvsnprintf function is used elsewhere in
qpopper, additional exploits may be possible.

The qpopper package in Debian 2.2 (potato) does not include the vulnerable
snprintf implementation. For Debian 3.0 (woody) an updated package is available
in version 4.0.4-2.woody.3. Users running an unreleased version of Debian
should upgrade to 4.0.4-9 or newer. We recommend you upgrade your qpopper
package immediately.



Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20259-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 259-1 (qpopper)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"qpopper", ver:"4.0.4-2.woody.3", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"qpopper-drac", ver:"4.0.4-2.woody.3", rls:"DEB3.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
