# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 268-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(53724);
 script_cve_id("CVE-2003-0140");
 script_bugtraq_id(7120);
 script_version ("$");
 name = "Debian Security Advisory DSA 268-1 (mutt)";
 script_name(name);

 desc = "The remote host is missing an update to mutt
announced via advisory DSA 268-1.

Core Security Technologies discovered a buffer overflow in the IMAP
code of Mutt, a text-oriented mail reader supporting IMAP, MIME, GPG,
PGP and threading.  This problem allows a remote malicious IMAP server
to cause a denial of service (crash) and possibly execute arbitrary
code via a specially crafted mail folder.

For the stable distribution (woody) this problem has been fixed in
version 1.3.28-2.1.

The old stable distribution (potato) is not affected by this problem.

For the unstable distribution (sid) this problem has been fixed in
version 1.5.4-1.

We recommend that you upgrade your mutt package.


Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20268-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 268-1 (mutt)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"mutt", ver:"1.3.28-2.1", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"mutt-utf8", ver:"1.3.28-2.1", rls:"DEB3.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
