# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 292-3
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(53367);
 script_version ("$");
 name = "Debian Security Advisory DSA 292-3 (mime-support)";
 script_name(name);

 desc = "The remote host is missing an update to mime-support
announced via advisory DSA 292-3.

I am awfully and sincerely sorry.  Apparently, I wasn't able to assign
enough time to this issue and produced insufficiently tested
updates.  I'll do my best not to repeat this.

This update fixes the second problem from the original advisory:

When run-mailcap is executed on a file with a potentially
problematic filename, a temporary file is created (not insecurely
anymore), removed and a symbolic link to this filename is created.
An attacker could recreate the file before the symbolic link is
created, forcing the display program to display different content.

For the stable distribution (woody) this problem has been corrected in
version 3.18-1.3.

For the old stable distribution (potato) this problem has been
corrected in version 3.9-1.3.

For the unstable distribution (sid) this problem has been fixed in
version 3.23-1.

We recommend that you upgrade your mime-support packages.


Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20292-3

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 292-3 (mime-support)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"mime-support", ver:"3.9-1.3", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"mime-support", ver:"3.18-1.3", rls:"DEB3.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
