# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 307-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(53598);
 script_version ("$");
 name = "Debian Security Advisory DSA 307-1 (ircii-pana)";
 script_name(name);

 desc = "The remote host is missing an update to ircii-pana
announced via advisory DSA 307-1.

Timo Sirainen discovered several problems in BitchX, a popular client
for Internet Relay Chat (IRC).  A malicious server could craft special
reply strings, triggering the client to write beyond buffer boundaries
or allocate a negative amount of memory.  This could lead to a denial
of service if the client only crashes, but may also lead to executing
of arbitrary code under the user id of the chatting user.

For the stable distribution (woody) these problems have been fixed in
version 1.0-0c19-1.1.

For the old stable distribution (potato) these problems have been
fixed in version 1.0-0c16-2.1.

For the unstable distribution (sid) these problems have been fixed in
version 1.0-0c19-8.

We recommend that you upgrade your BitchX package.


Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20307-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 307-1 (ircii-pana)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"bitchx", ver:"1.0-0c16-2.1", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"bitchx-gtk", ver:"1.0-0c16-2.1", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"bitchx", ver:"1.0-0c19-1.1", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"bitchx-dev", ver:"1.0-0c19-1.1", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"bitchx-gtk", ver:"1.0-0c19-1.1", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"bitchx-ssl", ver:"1.0-0c19-1.1", rls:"DEB3.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
