# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 324-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(53613);
 script_cve_id("CVE-2003-0428", "CVE-2003-0429", "CVE-2003-0431", "CVE-2003-0432");
 script_version ("$");
 name = "Debian Security Advisory DSA 324-1 (ethereal)";
 script_name(name);

 desc = "The remote host is missing an update to ethereal
announced via advisory DSA 324-1.

Several of the packet dissectors in ethereal contain string handling
bugs which could be exploited using a maliciously crafted packet to
cause ethereal to consume excessive amounts of memory, crash, or
execute arbitrary code.

These vulnerabilites were announced in the following Ethereal security
advisory:

http://www.ethereal.com/appnotes/enpa-sa-00010.html

Ethereal 0.9.4 in Debian 3.0 (woody) is affected by most of the
problems described in the advisory, including:

* The DCERPC dissector could try to allocate too much memory
while trying to decode an NDR string.
* Bad IPv4 or IPv6 prefix lengths could cause an overflow in the
OSI dissector.
* The tvb_get_nstringz0() routine incorrectly handled a
zero-length buffer size.
* The BGP, WTP, DNS, 802.11, ISAKMP, WSP, CLNP, and ISIS
dissectors handled strings improperly.

The following problems do NOT affect this version:

* The SPNEGO dissector could segfault while parsing an invalid
ASN.1 value.
* The RMI dissector handled strings improperly

as these modules are not present.

For the stable distribution (woody) these problems have been fixed in
version 0.9.4-1woody5.

The old stable distribution (potato) these problems will be fixed in a
future advisory.

For the unstable distribution (sid) these problems are fixed in
version 0.9.13-1.

We recommend that you update your ethereal package.



Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20324-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 324-1 (ethereal)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"ethereal", ver:"0.9.4-1woody5", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"ethereal-common", ver:"0.9.4-1woody5", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"ethereal-dev", ver:"0.9.4-1woody5", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"tethereal", ver:"0.9.4-1woody5", rls:"DEB3.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
