# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 332-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(53621);
 script_cve_id("CVE-2002-0429", "CVE-2003-0001", "CVE-2003-0127", "CVE-2003-0244", "CVE-2003-0246", "CVE-2003-0247", "CVE-2003-0248", "CVE-2003-0364");
 script_version ("$");
 name = "Debian Security Advisory DSA 332-1 (kernel-source-2.4.17, kernel-patch-2.4.17-mips)";
 script_name(name);

 desc = "The remote host is missing an update to kernel-source-2.4.17, kernel-patch-2.4.17-mips
announced via advisory DSA 332-1.

A number of vulnerabilities have been discovered in the Linux kernel.

- - CVE-2002-0429: The iBCS routines in arch/i386/kernel/traps.c for
Linux kernels 2.4.18 and earlier on x86 systems allow local users to
kill arbitrary processes via a a binary compatibility interface
(lcall)

- - CVE-2003-0001: Multiple ethernet Network Interface Card (NIC) device
drivers do not pad frames with null bytes, which allows remote
attackers to obtain information from previous packets or kernel
memory by using malformed packets

- - CVE-2003-0127: The kernel module loader allows local users to gain
root privileges by using ptrace to attach to a child process that is
spawned by the kernel

- - CVE-2003-0244: The route cache implementation in Linux 2.4, and the
Netfilter IP conntrack module, allows remote attackers to cause a
denial of service (CPU consumption) via packets with forged source
addresses that cause a large number of hash table collisions related
to the PREROUTING chain

- - CVE-2003-0246: The ioperm system call in Linux kernel 2.4.20 and
earlier does not properly restrict privileges, which allows local
users to gain read or write access to certain I/O ports.

- - CVE-2003-0247: vulnerability in the TTY layer of the Linux kernel
2.4 allows attackers to cause a denial of service ('kernel oops')

- - CVE-2003-0248: The mxcsr code in Linux kernel 2.4 allows attackers
to modify CPU state registers via a malformed address.

- - CVE-2003-0364: The TCP/IP fragment reassembly handling in the Linux
kernel 2.4 allows remote attackers to cause a denial of service (CPU
consumption) via certain packets that cause a large number of hash
table collisions

This advisory provides corrected source code for Linux 2.4.17, and
corrected binary kernel images for the mips and mipsel architectures.
Other versions and architectures will be covered by separate
advisories.

For the stable distribution (woody), these problems have been fixed in
kernel-source-2.4.17 version 2.4.17-1woody1 and
kernel-patch-2.4.17-mips version 2.4.17-0.020226.2.woody2.

For the unstable distribution (sid) these problems are fixed in
kernel-source-2.4.20 version 2.4.20-8.

We recommend that you update your kernel packages.

NOTE: A system reboot will be required immediately after the upgrade
in order to replace the running kernel.  Remember to read carefully
and follow the instructions given during the kernel upgrade process.



Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20332-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 332-1 (kernel-source-2.4.17, kernel-patch-2.4.17-mips)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"kernel-patch-2.4.17-mips", ver:"2.4.17-0.020226.2.woody2", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-headers-2.4.17", ver:"2.4.17-0.020226.2.woody2", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-image-2.4.17-r4k-ip22", ver:"2.4.17-0.020226.2.woody2", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-image-2.4.17-r5k-ip22", ver:"2.4.17-0.020226.2.woody2", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-image-2.4.17-r3k-kn02", ver:"2.4.17-0.020226.2.woody2", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-image-2.4.17-r4k-kn04", ver:"2.4.17-0.020226.2.woody2", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"mips-tools", ver:"2.4.17-0.020226.2.woody2", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-doc-2.4.17", ver:"2.4.17-1woody1", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-source-2.4.17", ver:"2.4.17-1woody1", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"mkcramfs", ver:"2.4.17-1woody1", rls:"DEB3.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
