# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 423-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(53122);
 script_cve_id("CVE-2003-0001", "CVE-2003-0018", "CVE-2003-0127", "CVE-2003-0461", "CVE-2003-0462", "CVE-2003-0476", "CVE-2003-0501", "CVE-2003-0550", "CVE-2003-0551", "CVE-2003-0552", "CVE-2003-0961", "CVE-2003-0985");
 script_version ("$");
 name = "Debian Security Advisory DSA 423-1 (kernel-image-2.4.17-ia64)";
 script_name(name);

 desc = "The remote host is missing an update to kernel-image-2.4.17-ia64
announced via advisory DSA 423-1.

The IA-64 maintainers fixed several security related bugs in the Linux
kernel 2.4.17 used for the IA-64 architecture, mostly by backporting
fixes from 2.4.18.  The resolved issues are identified by the appropriate
CVE identifiers:

CVE-2003-0001, CVE-2003-0018, CVE-2003-0127, CVE-2003-0461
CVE-2003-0462, CVE-2003-0476, CVE-2003-0501, CVE-2003-0550
CVE-2003-0551, CVE-2003-0552, CVE-2003-0961, CVE-2003-0985

For a more detailed description of the problems addressed,
please visit the referenced security advisory.

For the stable distribution (woody) this problem has been fixed in
version kernel-image-2.4.17-ia64 for the ia64 architecture.  Other
architectures are already or will be fixed separately.

For the unstable distribution (sid) this problem will be fixed soon
with newly uploaded packages.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20423-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 423-1 (kernel-image-2.4.17-ia64)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"kernel-source-2.4.17-ia64", ver:"011226.15", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-headers-2.4.17-ia64", ver:"011226.15", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-image-2.4.17-itanium", ver:"011226.15", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-image-2.4.17-itanium-smp", ver:"011226.15", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-image-2.4.17-mckinley", ver:"011226.15", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-image-2.4.17-mckinley-smp", ver:"011226.15", rls:"DEB3.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
