# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 431-2
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(53180);
 script_bugtraq_id(9543);
 script_cve_id("CVE-2003-0618");
 script_version ("$");
 name = "Debian Security Advisory DSA 431-2 (perl)";
 script_name(name);

 desc = "The remote host is missing an update to perl
announced via advisory DSA 431-2.

Paul Szabo discovered a number of similar bugs in suidperl, a helper
program to run perl scripts with setuid privileges.  By exploiting
these bugs, an attacker could abuse suidperl to discover information
about files (such as testing for their existence and some of their
permissions) that should not be accessible to unprivileged users.

DSA 431-1 incorporated a partial fix for this problem.  This advisory
includes a more complete fix which corrects some additional cases.

For the current stable distribution (woody) this problem has been
fixed in version 5.6.1-8.7.

For the unstable distribution, this problem has been fixed in version
5.8.3-3.

We recommend that you update your perl package if you have the
perl-suid package installed.



Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20431-2

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 431-2 (perl)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"libcgi-fast-perl", ver:"5.6.1-8.7", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"perl-doc", ver:"5.6.1-8.7", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"perl-modules", ver:"5.6.1-8.7", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libperl-dev", ver:"5.6.1-8.7", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libperl5.6", ver:"5.6.1-8.7", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"perl", ver:"5.6.1-8.7", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"perl-base", ver:"5.6.1-8.7", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"perl-debug", ver:"5.6.1-8.7", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"perl-suid", ver:"5.6.1-8.7", rls:"DEB3.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
