# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 455-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(53153);
 script_bugtraq_id(9718);
 script_cve_id("CVE-2004-0110");
 script_version ("$");
 name = "Debian Security Advisory DSA 455-1 (libxml, libxml2)";
 script_name(name);

 desc = "The remote host is missing an update to libxml, libxml2
announced via advisory DSA 455-1.

libxml2 is a library for manipulating XML files.

Yuuichi Teranishi discovered a flaw in libxml, the GNOME XML library.
When fetching a remote resource via FTP or HTTP, the library uses
special parsing routines which can overflow a buffer if passed a very
long URL.  If an attacker is able to find an application using libxml1
or libxml2 that parses remote resources and allows the attacker to
craft the URL, then this flaw could be used to execute arbitrary code.

For the stable distribution (woody) this problem has been fixed in
version 1.8.17-2woody1 of libxml and version 2.4.19-4woody1 of libxml2.

For the unstable distribution (sid) this problem has been fixed in
version 1.8.17-5 of libxml and version 2.6.6-1 of libxml2.

We recommend that you upgrade your libxml1 and libxml2 packages.


Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20455-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 455-1 (libxml, libxml2)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"libxml-dev", ver:"1.8.17-2woody1", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libxml1", ver:"1.8.17-2woody1", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libxml2", ver:"2.4.19-4woody1", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libxml2-dev", ver:"2.4.19-4woody1", rls:"DEB3.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
