# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 466-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(53163);
 script_bugtraq_id(9686);
 script_cve_id("CVE-2004-0077");
 script_version ("$");
 name = "Debian Security Advisory DSA 466-1 (kernel-source-2.2.10, kernel-image-2.2.10-powerpc-apus)";
 script_name(name);

 desc = "The remote host is missing an update to kernel-source-2.2.10, kernel-image-2.2.10-powerpc-apus
announced via advisory DSA 466-1.

Paul Starzetz and Wojciech Purczynski of isec.pl discovered a critical
security vulnerability in the memory management code of Linux inside
the mremap(2) system call.  Due to flushing the TLB (Translation
Lookaside Buffer, an address cache) too early it is possible for an
attacker to trigger a local root exploit.

The attack vectors for 2.4.x and 2.2.x kernels are exclusive for the
respective kernel series, though.  We formerly believed that the
exploitable vulnerability in 2.4.x does not exist in 2.2.x which is
still true.  However, it turned out that a second (sort of)
vulnerability is indeed exploitable in 2.2.x, but not in 2.4.x, with a
different exploit, of course.

For the stable distribution (woody) this problem has been fixed in
version 2.2.10-13woody1 of 2.2 kernel images for the powerpc/apus
architecture and in version 2.2.10-2 of Linux 2.2.10 source.

For the unstable distribution (sid) this problem will be fixed soon
with the 2.4.20 kernel-image package for powerpc/apus.  The old 2.2.10
kernel image will be removed from Debian unstable.

You are strongly advised to switch to the fixed 2.4.17 kernel-image
package for powerpc/apus from woody until the 2.4.20 kernel-image
package is fixed in the unstable distribution.

We recommend that you upgrade your Linux kernel package.


Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20466-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 466-1 (kernel-source-2.2.10, kernel-image-2.2.10-powerpc-apus)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"kernel-doc-2.2.10", ver:"2.2.10-2", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-source-2.2.10", ver:"2.2.10-2", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-headers-2.2.10-apus", ver:"2.2.10-13woody1", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-image-2.2.10-apus", ver:"2.2.10-13woody1", rls:"DEB3.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
