# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 485-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(53687);
 script_bugtraq_id(10150);
 script_cve_id("CVE-2004-0156");
 script_version ("$");
 name = "Debian Security Advisory DSA 485-1 (ssmtp)";
 script_name(name);

 desc = "The remote host is missing an update to ssmtp
announced via advisory DSA 485-1.

Max Vozeler discovered two format string vulnerabilities in ssmtp, a
simple mail transport agent.  Untrusted values in the functions die()
and log_event() were passed to printf-like functions as format
strings.  These vulnerabilities could potentially be exploited by a
remote mail relay to gain the privileges of the ssmtp process
(including potentially root).

For the current stable distribution (woody) this problem will be fixed
in version 2.50.6.1.

For the unstable distribution (sid), this problem will be fixed soon.

We recommend that you update your ssmtp package.



Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20485-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 485-1 (ssmtp)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"ssmtp", ver:"2.50.6.1", rls:"DEB3.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
