# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 509-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(53199);
 script_bugtraq_id(10437);
 script_cve_id("CVE-2004-0395");
 script_version ("$");
 name = "Debian Security Advisory DSA 509-1 (gatos)";
 script_name(name);

 desc = "The remote host is missing an update to gatos
announced via advisory DSA 509-1.

Steve Kemp discovered a vulnerability in xatitv, one of the programs
in the gatos package, which is used to display video with certain
ATI video cards.

xatitv is installed setuid root in order to gain direct access to the
video hardware.  It normally drops root privileges after successfully
initializing itself.  However, if initialization fails due to a
missing configuration file, root privileges are not dropped, and
xatitv executes the system(3) function to launch its configuration
program without sanitizing user-supplied environment variables.

By exploiting this vulnerability, a local user could gain root
privileges if the configuration file does not exist.  However, a
default configuration file is supplied with the package, and so this
vulnerability is not exploitable unless this file is removed by the
administrator.

For the current stable distribution (woody) this problem has been
fixed in version 0.0.5-6woody1.

For the unstable distribution (sid), this problem will be fixed soon.

We recommend that you update your gatos package.



Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20509-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 509-1 (gatos)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"gatos", ver:"0.0.5-6woody1", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libgatos-dev", ver:"0.0.5-6woody1", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libgatos0", ver:"0.0.5-6woody1", rls:"DEB3.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
