# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 515-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(53206);
 script_cve_id("CVE-2004-0234", "CVE-2004-0235");
 script_version ("$");
 name = "Debian Security Advisory DSA 515-1 (lha)";
 script_name(name);

 desc = "The remote host is missing an update to lha
announced via advisory DSA 515-1.

Two vulnerabilities were discovered in lha:

- CVE-2004-0234 - Multiple stack-based buffer overflows in the
get_header function in header.c for LHA 1.14 allow remote attackers
or local users to execute arbitrary code via long directory or file
names in an LHA archive, which triggers the overflow when testing
or extracting the archive.

- CVE-2004-0235 - Multiple directory traversal vulnerabilities in LHA
1.14 allow remote attackers or local users to create arbitrary
files via an LHA archive containing filenames with (1) .. sequences
or (2) absolute pathnames with double leading slashes
(//absolute/path).

For the current stable distribution (woody), these problems have been
fixed in version 1.14i-2woody1.

For the unstable distribution (sid), these problems have been fixed in
version 1.14i-8.

We recommend that you update your lha package.



Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20515-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 515-1 (lha)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"lha", ver:"1.14i-2woody1", rls:"DEB3.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
