# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 522-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(53212);
 script_cve_id("CVE-2004-0579");
 script_version ("$");
 name = "Debian Security Advisory DSA 522-1 (super)";
 script_name(name);

 desc = "The remote host is missing an update to super
announced via advisory DSA 522-1.

Max Vozeler discovered a format string vulnerability in super, a
program to allow specified users to execute commands with root
privileges.  This vulnerability could potentially be exploited by a
local user to execute arbitrary code with root privileges.

For the current stable distribution (woody), this problem has been
fixed in version 3.16.1-1.2.

For the unstable distribution (sid), this problem will has been fixed
in version 3.23.0-1.

We recommend that you update your super package.



Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20522-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 522-1 (super)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"super", ver:"3.16.1-1.2", rls:"DEB3.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
